<?php

header('Content-Type: application/json');



include 'db.php';
include 'tg.php';
include 'gs.php';
include 'func.php';





$db = new Db();
if ($db -> error) { echo json_encode(array('success' => false, 'error' => $db -> error), JSON_UNESCAPED_UNICODE); exit; }









class api
{
    public static function get_tasks($db, $token)
    {
        $source = $db -> get_source_by_token($token);
        if ($source == null) { echo json_encode(array('success' => false, 'error' => 'Invalid token'), JSON_UNESCAPED_UNICODE); exit; }
        
        return array('success' => true, 'tasks' => $db -> get_tasks($source));
    }

    public static function update_task($db, $token, $id, $data_output, $success)
    {
        $source = $db -> get_source_by_token($token);
        if ($source == null) { echo json_encode(array('success' => false, 'error' => 'Invalid token'), JSON_UNESCAPED_UNICODE); exit; }

        $db -> update_task($id, $data_output, $success);
       
        return array('success' => true);
    }

    public static function get_completed_tasks($db, $token, $source)
    {
        $source = $db -> get_source_by_token($token);
        if ($source == null) { echo json_encode(array('success' => false, 'error' => 'Invalid token'), JSON_UNESCAPED_UNICODE); exit; }

        $data = $db -> get_completed_tasks($source);
        if (count($data) == 0) return array('success' => true, 'id' => null);

        
        $file_path = __DIR__ . '/cloudflare_' . sprintf('%u', crc32($data[0]['message_id'])) . '.txt';
        $file_content = implode("\n", array_column($data, 'data_output'));

        file_put_contents($file_path, $file_content);
    
        $chat_id = $data[0]['chat_id'];
        sendFile($chat_id, $file_path, '✅ Задание <code>#' . sprintf('%u', crc32($data[0]['message_id'])) . '</code> выполнено');

        $db -> mark_sent($data[0]['message_id'], $source);

        return ['success' => true, 'id' => $data[0]['message_id']];
    }

    public static function notify($db, $token, $text)
    {
        $rows = $db -> get_rows(users, array('token' => $token));
        $chat_id = (count($rows) > 0) ? $rows[0]['chat_id'] : null;
        if ($chat_id) Send('sendMessage', array('chat_id' => $chat_id, 'text' => $text));
    }

    public static function add_rows_to_google_sheet($db, $token, $message_id)
    {
        $rows = $db -> get_rows(users, array('token' => $token));
        if (count($rows) == 0) { echo json_encode(array('success' => false, 'error' => 'Invalid token'), JSON_UNESCAPED_UNICODE); exit; }

        $user = $rows[0];

        $rows = $db -> get_rows(tasks, array('message_id' => $message_id));
        if (count($rows) == 0) { echo json_encode(array('success' => false, 'error' => 'No Rows'), JSON_UNESCAPED_UNICODE); exit; }

        $rows = Admin_Json :: build_rows_for_sheets($rows);

        $gs = new gs($user['source']);
        return $gs -> add_rows($user['google_sheet_id'], $user['google_tab_name'], $rows);
    }
}














if ($_SERVER['REQUEST_METHOD'] == 'GET')
{
    if ($_GET['act'] == 'get_tasks') { echo json_encode(api :: get_tasks($db, $_GET['token']), JSON_UNESCAPED_UNICODE); exit; }
    if ($_GET['act'] == 'get_completed_tasks') { echo json_encode(api :: get_completed_tasks($db, $_GET['token'], $_GET['source']), JSON_UNESCAPED_UNICODE); exit; }
    if ($_GET['act'] == 'add_rows_to_google_sheet') { echo json_encode(api :: add_rows_to_google_sheet($db, $_GET['token'], $_GET['message_id']), JSON_UNESCAPED_UNICODE); exit; }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $o = json_decode(file_get_contents('php://input'), true);

    if ($o['act'] == 'update_task') { echo json_encode(api :: update_task($db, $o['token'], $o['id'], $o['data_output'], $o['success']), JSON_UNESCAPED_UNICODE); exit; }
    if ($o['act'] == 'notify') { echo json_encode(api :: notify($db, $o['token'], $o['text']), JSON_UNESCAPED_UNICODE); exit; }
}




?>