<?php

class Admin_Mveb
{
    public static function get_data($content)
    {
        $lines = array_filter(array_map('trim', preg_split('/\r\n|\r|\n/', $content)));

        $data = array();
        foreach ($lines as $line)
        {
            $args = array_filter(array_map('trim', preg_split('/[:;,\|]/', $line)));
            if (count($args) < 2) continue;

            $domain = trim($args[0]);
            $ip = trim($args[1]);

            if ((bool)filter_var($domain, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME) != true) continue;
            if ((bool)(bool)filter_var($ip, FILTER_VALIDATE_IP) != true) continue;

            array_push($data, $line);
        }

        return $data;
    }
}

class Admin_Json
{
    public static function get_data($content)
    {
        $lines = array_filter(array_map('trim', preg_split('/\r\n|\r|\n/', $content)));

        $data = array();
        foreach ($lines as $line)
        {
            $args = array_filter(array_map('trim', preg_split('/[:;,\|]/', $line)));
            if (count($args) < 2) continue;

            $domain = trim($args[0]);
            $ip = trim($args[1]);

            if ((bool)filter_var($domain, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME) != true) continue;
            if ((bool)(bool)filter_var($ip, FILTER_VALIDATE_IP) != true) continue;

            array_push($data, $line);
        }

        return $data;
    }

    public static function build_rows_for_sheets($tasks)
    {
        if (empty($tasks)) return array();

        $chat_id = $tasks[0]['chat_id'];
        $rows = array();

        foreach ($tasks as $t)
        {
            $parts = explode(';', $t['data_output']);
            $parts[] = $chat_id;
            array_push($rows, $parts);
        }

        return $rows;
    }

}



?>