<?php

define('db', array('host' => 'localhost', 'port' => '', 'login' => 'u5573464_god', 'password' => 'a#XV(kM^*3+1-4w5', 'name' => 'u5573464_cf', 'charset' => 'utf8mb4'));

define('tasks', 'tasks');
define('users', 'users');

class Db
{
    private $dbo;

    public $error;

    public $user;
    public $state;

    public function __construct()
    {
        $this -> connect();
    }

    private function connect()
    {
        try
        {
            $this -> dbo = new PDO('mysql:host=' . db['host'] . ';port=' . db['port'] . ';dbname=' . db['name'] . ';charset=' . db['charset'], db['login'], db['password']);
            $this -> dbo -> setAttribute(PDO :: ATTR_ERRMODE, PDO :: ERRMODE_EXCEPTION);
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function user_identity($chat_id, $username, $first_name, $last_name)
    {
        try
        {
            $sql = 'SELECT * FROM `' . users . '` WHERE `chat_id` = :chat_id';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('chat_id' => $chat_id));
            
            $this -> user = $req -> fetch(PDO :: FETCH_ASSOC) ?: null;
            $this -> state = json_decode($this -> user['state'], true) ?: array();

            if ($this -> user && ($this -> user['username'] != $username || $this -> user['first_name'] != $first_name || $this -> user['last_name'] != $last_name))
            {
                $this -> update_row(users, array('chat_id' => $chat_id), array('username' => $username, 'first_name' => $first_name, 'last_name' => $last_name));

                $this -> user['username'] = $username;

                $this -> user['first_name'] = $first_name;
                $this -> user['last_name'] = $last_name;
            }
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function get_source_by_token($token)
    {
        try
        {
            $sql = 'SELECT source FROM `' . users . '` WHERE `token` = :token LIMIT 1';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('token' => $token));

            return $req -> fetch(PDO :: FETCH_COLUMN) ?: null;
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function get_tasks($source)
    {
        try
        {
            $sql = 'SELECT `id`, `data_input` FROM `' . tasks . '` WHERE `source` = :source AND `success` IS NULL AND `sent` IS NULL';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('source' => $source));

            return $req -> fetchAll(PDO :: FETCH_ASSOC);
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function get_active_tasks($source)
    {
        try
        {
            $sql = 'SELECT 
                    t.`message_id`,
                    COUNT(*) AS total,
                    SUM(CASE WHEN t.`success` = 1 THEN 1 ELSE 0 END) AS success_count,
                    SUM(CASE WHEN t.`success` = 0 THEN 1 ELSE 0 END) AS failed_count,
                    SUM(CASE WHEN t.`success` IS NULL THEN 1 ELSE 0 END) AS pending_count,
                    MIN(t.`chat_id`) AS chat_id,
                    MIN(t.`date`) AS date,
                    COALESCE(NULLIF(u.`username`, \'\'),
                             NULLIF(CONCAT_WS(\' \', u.`first_name`, u.`last_name`), \'\'),
                             MIN(t.`chat_id`)) AS sender
                FROM `' . tasks . '` t
                LEFT JOIN `' . users . '` u ON u.`chat_id` = t.`chat_id`
                WHERE t.`source` = :source AND t.`sent` IS NULL
                GROUP BY t.`message_id`
                ORDER BY MIN(t.`date`) ASC';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('source' => $source));

            return $req -> fetchAll(PDO :: FETCH_ASSOC);
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function update_task($id, $data_output, $success)
    {
        try
        {
            $sql = 'UPDATE `' . tasks . '` SET `data_output` = :data_output, `success` = :success WHERE `id` = :id';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('id' => $id, 'data_output' => $data_output, 'success' => $success));
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function add_new_user($chat_id, $source)
    {
        try
        {
            $sql = 'INSERT INTO `' . users . '` (chat_id, source, admin) VALUES (:chat_id, :source, 0)';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('chat_id' => $chat_id, 'source' => $source));
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    public function add_tasks($chat_id, $source, $rows, $message_id)
    {
        try
        {
            $guid = bin2hex(random_bytes(8));
            $date = date('Y-m-d H:i:s');

            $sql = 'INSERT INTO `' . tasks . '` (chat_id, data_input, source, date, message_id) VALUES (:chat_id, :data_input, :source, :date, :message_id)';
            $req = $this -> dbo -> prepare($sql);

            foreach ($rows as $row) $req -> execute(array('chat_id' => $chat_id, 'data_input' => $row, 'source' => $source, 'date' => $date, 'message_id' => $message_id));
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }







    public function get_completed_tasks($source)
{
    try
    {
        // 1) ищем message_id, где все success != NULL и sent IS NULL
        $sql = 'SELECT t.`message_id`
                FROM `' . tasks . '` t
                WHERE t.`source` = :source AND t.`sent` IS NULL
                GROUP BY t.`message_id`
                HAVING SUM(t.`success` IS NULL) = 0
                ORDER BY MIN(t.`date`) ASC
                LIMIT 1';

        $req = $this -> dbo -> prepare($sql);
        $req -> execute(array('source' => $source));
        $message_id = $req -> fetchColumn();

        if ($message_id == false) return array();

        // 2) возвращаем все строки найденной пачки
        $sql = 'SELECT * FROM `' . tasks . '` WHERE `message_id` = :message_id AND `source` = :source';
        $req = $this -> dbo -> prepare($sql);
        $req -> execute(array('message_id' => $message_id, 'source' => $source));

        return $req -> fetchAll(PDO :: FETCH_ASSOC) ?: array();
    }
    catch (PDOException $error)
    {
        $this -> error = $error -> getMessage();
        return array();
    }
}

public function mark_sent($message_id, $source)
{
    try
    {
        $sql = 'UPDATE `' . tasks . '` SET `sent` = 1 WHERE `message_id` = :message_id AND `source` = :source';
        $req = $this -> dbo -> prepare($sql);
        $req -> execute(array('message_id' => $message_id, 'source' => $source));

        return array('success' => true, 'count' => $req -> rowCount());
    }
    catch (PDOException $error) { $this -> error = $error -> getMessage(); return array('success' => false); }
}






    public function delete_rows($table_name, $where)
    {
        try
        {
            $w = array(); $params = array();

            foreach ($where as $key => $val)
            {
                $w[] = '`' . $key . '` = :w_' . $key;
                $params['w_' . $key] = $val;
            }

            $sql = 'DELETE FROM `' . $table_name . '` WHERE ' . implode(' AND ', $w);
            $req = $this->dbo->prepare($sql);
            foreach ($params as $k => $v) $req->bindValue(':' . $k, $v);
            $req->execute();
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }





    public function update_row($table_name, $where, $set)
    {
        try
        {
            $w = array(); $s = array(); $params = array();

            foreach ($set as $key => $val) { $s[] = '`' . $key . '` = :' . $key; $params[$key] = $val; }
            foreach ($where as $key => $val) { $w[] = '`' . $key . '` = :w_' . $key; $params['w_' . $key] = $val; }

            $sql = 'UPDATE `' . $table_name . '` SET ' . implode(', ', $s) . ' WHERE ' . implode(' AND ', $w);
            $req = $this->dbo->prepare($sql);
            foreach ($params as $k => $v) $req->bindValue(':' . $k, $v);
            $req->execute();

            return array('success' => true);
        }
        catch (PDOException $e) { return array('success' => false, 'text' => $e->getMessage()); }
    }

    public function get_row($table_name, $query)
    {
        try
        {
            $where  = array();
            $params = array();

            foreach ($query as $key => $value)
            {
            if (is_null($value))
            {
                $where[] = '`' . $key . '` IS NULL';
            }
            else if (is_string($value) && $value !== '' && $value[0] === '*')
            {
                $where[] = '`' . $key . '` LIKE :' . $key;
                $params[$key] = '%' . ltrim($value, '*') . '%';
            }
            else
            {
                $where[] = '`' . $key . '` = :' . $key;
                $params[$key] = $value;
            }
        }

            $sql = 'SELECT * FROM `' . $table_name . '`' . (empty($where) ? '' : ' WHERE ' . implode(' AND ', $where)) . ' LIMIT 1';

            $req = $this -> dbo -> prepare($sql);
            foreach ($params as $k => $v) $req -> bindValue(':' . $k, $v);
            $req -> execute();

            return $req -> fetch(PDO :: FETCH_ASSOC) ?: null;
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); return null; }
    }
    

    public function get_rows($table_name, $query)
    {
        try
        {
            $where  = array();
            $params = array();

            foreach ($query as $key => $value)
            {
                if (is_null($value))
                {
                    $where[] = '`' . $key . '` IS NULL';
                }
                else if (is_string($value) && $value !== '' && $value[0] === '*')
                {
                    $where[] = '`' . $key . '` LIKE :' . $key;
                    $params[$key] = '%' . ltrim($value, '*') . '%';
                }
                else
                {
                    $where[] = '`' . $key . '` = :' . $key;
                    $params[$key] = $value;
                }
            }

            $sql = 'SELECT * FROM `' . $table_name . '`' . (empty($where) ? '' : ' WHERE ' . implode(' AND ', $where));

            $req = $this -> dbo -> prepare($sql);
            foreach ($params as $k => $v) $req -> bindValue(':' . $k, $v);
            $req -> execute();

            $rows = $req -> fetchAll(PDO :: FETCH_ASSOC) ?: array();
            return $rows;
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }

    

    

    
    public function get_users($source)
    {
        try
        {
            $sql = 'SELECT * FROM `' . users . '` WHERE `source` = :source AND `admin` = :admin';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('source' => $source, 'admin' => 0));

            return $req -> fetchAll(PDO :: FETCH_ASSOC);
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); }
    }



    public function new_user($chat_id)
    {
        try
        {
            $req = $this -> dbo -> prepare('SELECT COUNT(*) FROM `' . users . '` WHERE `chat_id` = :chat_id');
            $req -> execute(array('chat_id' => $chat_id));

            return  $req -> fetchColumn() > 0 ? false : true;
        }
        catch (PDOException $e) { $this -> error = $e -> getMessage(); }
    }








    



    public function delete_user($chat_id)
    {
        try
        {
            $sql = 'DELETE FROM `' . users . '` WHERE `chat_id` = :chat_id';

            $req = $this -> dbo -> prepare($sql);
            $req -> execute(array('chat_id' => $chat_id));

            return array('success' => true);
        }
        catch (PDOException $error) { $this -> error = $error -> getMessage(); return array('success' => false); }
    }
}

?>